import java.rmi.*;


/**
 * L'interfaccia INewsgroupClient serve per realizzare la 
 * callback di java Rmi. Il meccanismo di callback permette 
 * ad un client di essere notificato dal server al verificarsi 
 * dellevento per cui si  registrato e messo in attesa, senza 
 * dover fare polling.
 * Nell'interfaccia sono dichiarati i metodi remoti necessari al 
 * server per invocare la callback.
 * 
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 */
public interface INewsgroupClient extends Remote  {
	/**
	 * Metodo da cui si possono avere le informazioni riguardanti il cliente 
	 * @return i dati propri del cliente
	 * @throws RemoteException
	 */
	public Person who() throws RemoteException;
	
	/**
	 * Metodo di callback invocato dal server
	 * @param mess i messaggi  del newsgroup di interesse del cliente
	 * @throws RemoteException
	 */
	public  void callback(Msg []mess) throws RemoteException;
	
	/**
	 * Metodo di callback invocato dal server
	 * @param mess il messaggio  del newsgroup di interesse del cliente
	 * @throws RemoteException
	 */
	public  void callback(Msg mess) throws RemoteException;
	
	/**
	 * Metodo di callback invocato dal server per eventuali altre comunicazioni
	 * @param s stringa ricevuta dal server
	 * @throws RemoteException
	 */
	public void callback(String s)throws RemoteException;
	
	/**
	 * Metodo che ritorna i messaggi arrivati con la callback
	 * @return array di messaggi
	 * @throws RemoteException
	 */
	public Msg[] getMsgs()throws RemoteException;
}
